package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** NetworkPolicyList is a list of NetworkPolicy objects. */
final case class NetworkPolicyList(
  items : Seq[io.k8s.api.networking.v1.NetworkPolicy],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "NetworkPolicyList", "v1")

  def withItems(value: Seq[io.k8s.api.networking.v1.NetworkPolicy]) : NetworkPolicyList = copy(items = value)
  def addItems(newValues: io.k8s.api.networking.v1.NetworkPolicy*) : NetworkPolicyList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NetworkPolicyList = copy(metadata = Some(value))
}

