package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** NetworkPolicy describes what network traffic is allowed for a set of Pods */
final case class NetworkPolicy(
  status : Option[io.k8s.api.networking.v1.NetworkPolicyStatus] = None,
  spec : Option[io.k8s.api.networking.v1.NetworkPolicySpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "NetworkPolicy", "v1")

  def withStatus(value: io.k8s.api.networking.v1.NetworkPolicyStatus) : NetworkPolicy = copy(status = Some(value))
  def withSpec(value: io.k8s.api.networking.v1.NetworkPolicySpec) : NetworkPolicy = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : NetworkPolicy = copy(metadata = Some(value))
}

