package io.k8s.api.networking.v1


/** IngressTLS describes the transport layer security associated with an Ingress. */
final case class IngressTLS(
  hosts : Option[Seq[String]] = None,
  secretName : Option[String] = None
) {
  def withHosts(value: Seq[String]) : IngressTLS = copy(hosts = Some(value))
  def addHosts(newValues: String*) : IngressTLS = copy(hosts = Some(hosts.fold(newValues)(_ ++ newValues)))

  def withSecretName(value: String) : IngressTLS = copy(secretName = Some(value))
}

