package io.k8s.api.networking.v1


/** IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue. */
final case class IngressRule(
  host : Option[String] = None,
  http : Option[io.k8s.api.networking.v1.HTTPIngressRuleValue] = None
) {
  def withHost(value: String) : IngressRule = copy(host = Some(value))
  def withHttp(value: io.k8s.api.networking.v1.HTTPIngressRuleValue) : IngressRule = copy(http = Some(value))
}

