package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** IngressList is a collection of Ingress. */
final case class IngressList(
  items : Seq[io.k8s.api.networking.v1.Ingress],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressList", "v1")

  def withItems(value: Seq[io.k8s.api.networking.v1.Ingress]) : IngressList = copy(items = value)
  def addItems(newValues: io.k8s.api.networking.v1.Ingress*) : IngressList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressList = copy(metadata = Some(value))
}

