package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** IngressClass represents the class of the Ingress, referenced by the Ingress Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class. */
final case class IngressClass(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1.IngressClassSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressClass", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : IngressClass = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.networking.v1.IngressClassSpec) : IngressClass = copy(spec = Some(value))
}

