package io.k8s.api.networking.v1


/** IngressBackend describes all endpoints for a given service and port. */
final case class IngressBackend(
  resource : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  service : Option[io.k8s.api.networking.v1.IngressServiceBackend] = None
) {
  def withResource(value: io.k8s.api.core.v1.TypedLocalObjectReference) : IngressBackend = copy(resource = Some(value))
  def withService(value: io.k8s.api.networking.v1.IngressServiceBackend) : IngressBackend = copy(service = Some(value))
}

