package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc. */
final case class Ingress(
  status : Option[io.k8s.api.networking.v1.IngressStatus] = None,
  spec : Option[io.k8s.api.networking.v1.IngressSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "Ingress", "v1")

  def withStatus(value: io.k8s.api.networking.v1.IngressStatus) : Ingress = copy(status = Some(value))
  def withSpec(value: io.k8s.api.networking.v1.IngressSpec) : Ingress = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Ingress = copy(metadata = Some(value))
}

