package io.k8s.api.networking.v1


/** HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend. */
final case class HTTPIngressPath(
  backend : io.k8s.api.networking.v1.IngressBackend,
  path : Option[String] = None,
  pathType : String
) {
  def withBackend(value: io.k8s.api.networking.v1.IngressBackend) : HTTPIngressPath = copy(backend = value)
  def withPath(value: String) : HTTPIngressPath = copy(path = Some(value))
  def withPathType(value: String) : HTTPIngressPath = copy(pathType = value)
}

