package io.k8s.api.flowcontrol.v1beta2


/** PriorityLevelConfigurationCondition defines the condition of priority level. */
final case class PriorityLevelConfigurationCondition(
  reason : Option[String] = None,
  status : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : Option[String] = None
) {
  def withReason(value: String) : PriorityLevelConfigurationCondition = copy(reason = Some(value))
  def withStatus(value: String) : PriorityLevelConfigurationCondition = copy(status = Some(value))
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PriorityLevelConfigurationCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : PriorityLevelConfigurationCondition = copy(message = Some(value))
  def withType(value: String) : PriorityLevelConfigurationCondition = copy(`type` = Some(value))
}

