package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._

/** PriorityLevelConfiguration represents the configuration of a priority level. */
final case class PriorityLevelConfiguration(
  status : Option[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus] = None,
  spec : Option[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "PriorityLevelConfiguration", "v1beta2")

  def withStatus(value: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus) : PriorityLevelConfiguration = copy(status = Some(value))
  def withSpec(value: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec) : PriorityLevelConfiguration = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PriorityLevelConfiguration = copy(metadata = Some(value))
}

