package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._

/** FlowSchemaList is a list of FlowSchema objects. */
final case class FlowSchemaList(
  items : Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchemaList", "v1beta2")

  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema]) : FlowSchemaList = copy(items = value)
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta2.FlowSchema*) : FlowSchemaList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : FlowSchemaList = copy(metadata = Some(value))
}

