package io.k8s.api.flowcontrol.v1beta1


/** FlowSchemaSpec describes how the FlowSchema's specification looks like. */
final case class FlowSchemaSpec(
  distinguisherMethod : Option[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod] = None,
  matchingPrecedence : Option[Int] = None,
  priorityLevelConfiguration : io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference,
  rules : Option[Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]] = None
) {
  def withDistinguisherMethod(value: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = Some(value))
  def withMatchingPrecedence(value: Int) : FlowSchemaSpec = copy(matchingPrecedence = Some(value))
  def withPriorityLevelConfiguration(value: io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = value)
  def withRules(value: Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects*) : FlowSchemaSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

}

