package io.k8s.api.flowcontrol.v1beta1


/** FlowSchemaCondition describes conditions for a FlowSchema. */
final case class FlowSchemaCondition(
  reason : Option[String] = None,
  status : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : Option[String] = None
) {
  def withReason(value: String) : FlowSchemaCondition = copy(reason = Some(value))
  def withStatus(value: String) : FlowSchemaCondition = copy(status = Some(value))
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : FlowSchemaCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : FlowSchemaCondition = copy(message = Some(value))
  def withType(value: String) : FlowSchemaCondition = copy(`type` = Some(value))
}

