package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s._

/** FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher". */
final case class FlowSchema(
  status : Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus] = None,
  spec : Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchema", "v1beta1")

  def withStatus(value: io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus) : FlowSchema = copy(status = Some(value))
  def withSpec(value: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec) : FlowSchema = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : FlowSchema = copy(metadata = Some(value))
}

