package io.k8s.api.events.v1


/** EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is updated on heartbeats and can guide customized reporter implementations. */
final case class EventSeries(
  count : Int,
  lastObservedTime : io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime
) {
  def withCount(value: Int) : EventSeries = copy(count = value)
  def withLastObservedTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = value)
}

