package io.k8s.api.core.v1


/** WindowsSecurityContextOptions contain Windows-specific options and credentials. */
final case class WindowsSecurityContextOptions(
  gmsaCredentialSpec : Option[String] = None,
  gmsaCredentialSpecName : Option[String] = None,
  hostProcess : Option[Boolean] = None,
  runAsUserName : Option[String] = None
) {
  def withGmsaCredentialSpec(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpec = Some(value))
  def withGmsaCredentialSpecName(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpecName = Some(value))
  def withHostProcess(value: Boolean) : WindowsSecurityContextOptions = copy(hostProcess = Some(value))
  def withRunAsUserName(value: String) : WindowsSecurityContextOptions = copy(runAsUserName = Some(value))
}

