package io.k8s.api.core.v1


/** Represents a vSphere volume resource. */
final case class VsphereVirtualDiskVolumeSource(
  fsType : Option[String] = None,
  storagePolicyID : Option[String] = None,
  storagePolicyName : Option[String] = None,
  volumePath : String
) {
  def withFsType(value: String) : VsphereVirtualDiskVolumeSource = copy(fsType = Some(value))
  def withStoragePolicyID(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyID = Some(value))
  def withStoragePolicyName(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyName = Some(value))
  def withVolumePath(value: String) : VsphereVirtualDiskVolumeSource = copy(volumePath = value)
}

