package io.k8s.api.core.v1


/** VolumeMount describes a mounting of a Volume within a container. */
final case class VolumeMount(
  subPath : Option[String] = None,
  name : String,
  mountPropagation : Option[String] = None,
  readOnly : Option[Boolean] = None,
  mountPath : String,
  subPathExpr : Option[String] = None
) {
  def withSubPath(value: String) : VolumeMount = copy(subPath = Some(value))
  def withName(value: String) : VolumeMount = copy(name = value)
  def withMountPropagation(value: String) : VolumeMount = copy(mountPropagation = Some(value))
  def withReadOnly(value: Boolean) : VolumeMount = copy(readOnly = Some(value))
  def withMountPath(value: String) : VolumeMount = copy(mountPath = value)
  def withSubPathExpr(value: String) : VolumeMount = copy(subPathExpr = Some(value))
}

