package io.k8s.api.core.v1


/** TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace. */
final case class TypedLocalObjectReference(
  apiGroup : Option[String] = None,
  name : String
) {
  def withApiGroup(value: String) : TypedLocalObjectReference = copy(apiGroup = Some(value))
  def withName(value: String) : TypedLocalObjectReference = copy(name = value)
}

