package io.k8s.api.core.v1


/** TopologySpreadConstraint specifies how to spread matching pods among the given topology. */
final case class TopologySpreadConstraint(
  maxSkew : Int,
  matchLabelKeys : Option[Seq[String]] = None,
  minDomains : Option[Int] = None,
  labelSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  nodeAffinityPolicy : Option[String] = None,
  nodeTaintsPolicy : Option[String] = None,
  topologyKey : String,
  whenUnsatisfiable : String
) {
  def withMaxSkew(value: Int) : TopologySpreadConstraint = copy(maxSkew = value)
  def withMatchLabelKeys(value: Seq[String]) : TopologySpreadConstraint = copy(matchLabelKeys = Some(value))
  def addMatchLabelKeys(newValues: String*) : TopologySpreadConstraint = copy(matchLabelKeys = Some(matchLabelKeys.fold(newValues)(_ ++ newValues)))

  def withMinDomains(value: Int) : TopologySpreadConstraint = copy(minDomains = Some(value))
  def withLabelSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : TopologySpreadConstraint = copy(labelSelector = Some(value))
  def withNodeAffinityPolicy(value: String) : TopologySpreadConstraint = copy(nodeAffinityPolicy = Some(value))
  def withNodeTaintsPolicy(value: String) : TopologySpreadConstraint = copy(nodeTaintsPolicy = Some(value))
  def withTopologyKey(value: String) : TopologySpreadConstraint = copy(topologyKey = value)
  def withWhenUnsatisfiable(value: String) : TopologySpreadConstraint = copy(whenUnsatisfiable = value)
}

