package io.k8s.api.core.v1


/** TCPSocketAction describes an action based on opening a socket */
final case class TCPSocketAction(
  host : Option[String] = None,
  port : io.k8s.apimachinery.pkg.util.intstr.IntOrString
) {
  def withHost(value: String) : TCPSocketAction = copy(host = Some(value))
  def withPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : TCPSocketAction = copy(port = value)
}

