package io.k8s.api.core.v1


/** Represents a StorageOS persistent volume resource. */
final case class StorageOSVolumeSource(
  volumeNamespace : Option[String] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  volumeName : Option[String] = None
) {
  def withVolumeNamespace(value: String) : StorageOSVolumeSource = copy(volumeNamespace = Some(value))
  def withReadOnly(value: Boolean) : StorageOSVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : StorageOSVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : StorageOSVolumeSource = copy(secretRef = Some(value))
  def withVolumeName(value: String) : StorageOSVolumeSource = copy(volumeName = Some(value))
}

