package io.k8s.api.core.v1


/** Represents a StorageOS persistent volume resource. */
final case class StorageOSPersistentVolumeSource(
  volumeNamespace : Option[String] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.ObjectReference] = None,
  volumeName : Option[String] = None
) {
  def withVolumeNamespace(value: String) : StorageOSPersistentVolumeSource = copy(volumeNamespace = Some(value))
  def withReadOnly(value: Boolean) : StorageOSPersistentVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : StorageOSPersistentVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.ObjectReference) : StorageOSPersistentVolumeSource = copy(secretRef = Some(value))
  def withVolumeName(value: String) : StorageOSPersistentVolumeSource = copy(volumeName = Some(value))
}

