package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceList holds a list of services. */
final case class ServiceList(
  items : Seq[io.k8s.api.core.v1.Service],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Service]) : ServiceList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Service*) : ServiceList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceList = copy(metadata = Some(value))
}

