package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy. */
final case class Service(
  status : Option[io.k8s.api.core.v1.ServiceStatus] = None,
  spec : Option[io.k8s.api.core.v1.ServiceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Service", "v1")

  def withStatus(value: io.k8s.api.core.v1.ServiceStatus) : Service = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.ServiceSpec) : Service = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Service = copy(metadata = Some(value))
}

