package io.k8s.api.core.v1


/** SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence. */
final case class SecurityContext(
  capabilities : Option[io.k8s.api.core.v1.Capabilities] = None,
  readOnlyRootFilesystem : Option[Boolean] = None,
  allowPrivilegeEscalation : Option[Boolean] = None,
  procMount : Option[String] = None,
  runAsGroup : Option[Int] = None,
  seccompProfile : Option[io.k8s.api.core.v1.SeccompProfile] = None,
  windowsOptions : Option[io.k8s.api.core.v1.WindowsSecurityContextOptions] = None,
  seLinuxOptions : Option[io.k8s.api.core.v1.SELinuxOptions] = None,
  runAsUser : Option[Int] = None,
  privileged : Option[Boolean] = None,
  runAsNonRoot : Option[Boolean] = None
) {
  def withCapabilities(value: io.k8s.api.core.v1.Capabilities) : SecurityContext = copy(capabilities = Some(value))
  def withReadOnlyRootFilesystem(value: Boolean) : SecurityContext = copy(readOnlyRootFilesystem = Some(value))
  def withAllowPrivilegeEscalation(value: Boolean) : SecurityContext = copy(allowPrivilegeEscalation = Some(value))
  def withProcMount(value: String) : SecurityContext = copy(procMount = Some(value))
  def withRunAsGroup(value: Int) : SecurityContext = copy(runAsGroup = Some(value))
  def withSeccompProfile(value: io.k8s.api.core.v1.SeccompProfile) : SecurityContext = copy(seccompProfile = Some(value))
  def withWindowsOptions(value: io.k8s.api.core.v1.WindowsSecurityContextOptions) : SecurityContext = copy(windowsOptions = Some(value))
  def withSeLinuxOptions(value: io.k8s.api.core.v1.SELinuxOptions) : SecurityContext = copy(seLinuxOptions = Some(value))
  def withRunAsUser(value: Int) : SecurityContext = copy(runAsUser = Some(value))
  def withPrivileged(value: Boolean) : SecurityContext = copy(privileged = Some(value))
  def withRunAsNonRoot(value: Boolean) : SecurityContext = copy(runAsNonRoot = Some(value))
}

