package io.k8s.api.core.v1


/** SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace */
final case class SecretReference(
  name : Option[String] = None,
  namespace : Option[String] = None
) {
  def withName(value: String) : SecretReference = copy(name = Some(value))
  def withNamespace(value: String) : SecretReference = copy(namespace = Some(value))
}

