package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes. */
final case class Secret(
  data : Option[Map[String, String]] = None,
  immutable : Option[Boolean] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  `type` : Option[String] = None,
  stringData : Option[Map[String, String]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Secret", "v1")

  def withData(value: Map[String, String]) : Secret = copy(data = Some(value))
  def addData(newValues: (String, String)*) : Secret = copy(data = Some(data.fold(newValues.toMap)(_ ++ newValues)))

  def withImmutable(value: Boolean) : Secret = copy(immutable = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Secret = copy(metadata = Some(value))
  def withType(value: String) : Secret = copy(`type` = Some(value))
  def withStringData(value: Map[String, String]) : Secret = copy(stringData = Some(value))
  def addStringData(newValues: (String, String)*) : Secret = copy(stringData = Some(stringData.fold(newValues.toMap)(_ ++ newValues)))

}

