package io.k8s.api.core.v1


/** A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values. */
final case class ScopedResourceSelectorRequirement(
  operator : String,
  scopeName : String,
  values : Option[Seq[String]] = None
) {
  def withOperator(value: String) : ScopedResourceSelectorRequirement = copy(operator = value)
  def withScopeName(value: String) : ScopedResourceSelectorRequirement = copy(scopeName = value)
  def withValues(value: Seq[String]) : ScopedResourceSelectorRequirement = copy(values = Some(value))
  def addValues(newValues: String*) : ScopedResourceSelectorRequirement = copy(values = Some(values.fold(newValues)(_ ++ newValues)))

}

