package io.k8s.api.core.v1


/** ScaleIOVolumeSource represents a persistent ScaleIO volume */
final case class ScaleIOVolumeSource(
  system : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : io.k8s.api.core.v1.LocalObjectReference,
  storagePool : Option[String] = None,
  gateway : String,
  protectionDomain : Option[String] = None,
  volumeName : Option[String] = None,
  sslEnabled : Option[Boolean] = None,
  storageMode : Option[String] = None
) {
  def withSystem(value: String) : ScaleIOVolumeSource = copy(system = value)
  def withReadOnly(value: Boolean) : ScaleIOVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : ScaleIOVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : ScaleIOVolumeSource = copy(secretRef = value)
  def withStoragePool(value: String) : ScaleIOVolumeSource = copy(storagePool = Some(value))
  def withGateway(value: String) : ScaleIOVolumeSource = copy(gateway = value)
  def withProtectionDomain(value: String) : ScaleIOVolumeSource = copy(protectionDomain = Some(value))
  def withVolumeName(value: String) : ScaleIOVolumeSource = copy(volumeName = Some(value))
  def withSslEnabled(value: Boolean) : ScaleIOVolumeSource = copy(sslEnabled = Some(value))
  def withStorageMode(value: String) : ScaleIOVolumeSource = copy(storageMode = Some(value))
}

