package io.k8s.api.core.v1


/** SELinuxOptions are the labels to be applied to the container */
final case class SELinuxOptions(
  level : Option[String] = None,
  role : Option[String] = None,
  `type` : Option[String] = None,
  user : Option[String] = None
) {
  def withLevel(value: String) : SELinuxOptions = copy(level = Some(value))
  def withRole(value: String) : SELinuxOptions = copy(role = Some(value))
  def withType(value: String) : SELinuxOptions = copy(`type` = Some(value))
  def withUser(value: String) : SELinuxOptions = copy(user = Some(value))
}

