package io.k8s.api.core.v1


/** ResourceQuotaStatus defines the enforced hard limits and observed use. */
final case class ResourceQuotaStatus(
  hard : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  used : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withHard(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(hard = Some(value))
  def addHard(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceQuotaStatus = copy(hard = Some(hard.fold(newValues.toMap)(_ ++ newValues)))

  def withUsed(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(used = Some(value))
  def addUsed(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceQuotaStatus = copy(used = Some(used.fold(newValues.toMap)(_ ++ newValues)))

}

