package io.k8s.api.core.v1


/** ResourceQuotaSpec defines the desired hard limits to enforce for Quota. */
final case class ResourceQuotaSpec(
  hard : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  scopeSelector : Option[io.k8s.api.core.v1.ScopeSelector] = None,
  scopes : Option[Seq[String]] = None
) {
  def withHard(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaSpec = copy(hard = Some(value))
  def addHard(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceQuotaSpec = copy(hard = Some(hard.fold(newValues.toMap)(_ ++ newValues)))

  def withScopeSelector(value: io.k8s.api.core.v1.ScopeSelector) : ResourceQuotaSpec = copy(scopeSelector = Some(value))
  def withScopes(value: Seq[String]) : ResourceQuotaSpec = copy(scopes = Some(value))
  def addScopes(newValues: String*) : ResourceQuotaSpec = copy(scopes = Some(scopes.fold(newValues)(_ ++ newValues)))

}

