package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ResourceQuotaList is a list of ResourceQuota items. */
final case class ResourceQuotaList(
  items : Seq[io.k8s.api.core.v1.ResourceQuota],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ResourceQuotaList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.ResourceQuota]) : ResourceQuotaList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.ResourceQuota*) : ResourceQuotaList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceQuotaList = copy(metadata = Some(value))
}

