package io.k8s.api.core.v1


/** ReplicationControllerStatus represents the current status of a replication controller. */
final case class ReplicationControllerStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.ReplicationControllerCondition]] = None,
  replicas : Int,
  availableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  readyReplicas : Option[Int] = None,
  fullyLabeledReplicas : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.core.v1.ReplicationControllerCondition]) : ReplicationControllerStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.core.v1.ReplicationControllerCondition*) : ReplicationControllerStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withReplicas(value: Int) : ReplicationControllerStatus = copy(replicas = value)
  def withAvailableReplicas(value: Int) : ReplicationControllerStatus = copy(availableReplicas = Some(value))
  def withObservedGeneration(value: Int) : ReplicationControllerStatus = copy(observedGeneration = Some(value))
  def withReadyReplicas(value: Int) : ReplicationControllerStatus = copy(readyReplicas = Some(value))
  def withFullyLabeledReplicas(value: Int) : ReplicationControllerStatus = copy(fullyLabeledReplicas = Some(value))
}

