package io.k8s.api.core.v1


/** ReplicationControllerCondition describes the state of a replication controller at a certain point. */
final case class ReplicationControllerCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : ReplicationControllerCondition = copy(reason = Some(value))
  def withStatus(value: String) : ReplicationControllerCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicationControllerCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : ReplicationControllerCondition = copy(message = Some(value))
  def withType(value: String) : ReplicationControllerCondition = copy(`type` = value)
}

