package io.k8s.api.core.v1


/** Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling. */
final case class QuobyteVolumeSource(
  registry : String,
  readOnly : Option[Boolean] = None,
  tenant : Option[String] = None,
  group : Option[String] = None,
  user : Option[String] = None,
  volume : String
) {
  def withRegistry(value: String) : QuobyteVolumeSource = copy(registry = value)
  def withReadOnly(value: Boolean) : QuobyteVolumeSource = copy(readOnly = Some(value))
  def withTenant(value: String) : QuobyteVolumeSource = copy(tenant = Some(value))
  def withGroup(value: String) : QuobyteVolumeSource = copy(group = Some(value))
  def withUser(value: String) : QuobyteVolumeSource = copy(user = Some(value))
  def withVolume(value: String) : QuobyteVolumeSource = copy(volume = value)
}

