package io.k8s.api.core.v1


/** PortworxVolumeSource represents a Portworx volume resource. */
final case class PortworxVolumeSource(
  fsType : Option[String] = None,
  readOnly : Option[Boolean] = None,
  volumeID : String
) {
  def withFsType(value: String) : PortworxVolumeSource = copy(fsType = Some(value))
  def withReadOnly(value: Boolean) : PortworxVolumeSource = copy(readOnly = Some(value))
  def withVolumeID(value: String) : PortworxVolumeSource = copy(volumeID = value)
}

