package io.k8s.api.core.v1



final case class PortStatus(
  error : Option[String] = None,
  port : Int,
  protocol : String
) {
  def withError(value: String) : PortStatus = copy(error = Some(value))
  def withPort(value: Int) : PortStatus = copy(port = value)
  def withProtocol(value: String) : PortStatus = copy(protocol = value)
}

