package io.k8s.api.core.v1


/** PodTemplateSpec describes the data a pod should have when created from a template */
final case class PodTemplateSpec(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.core.v1.PodSpec] = None
) {
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplateSpec = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.core.v1.PodSpec) : PodTemplateSpec = copy(spec = Some(value))
}

