package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PodTemplateList is a list of PodTemplates. */
final case class PodTemplateList(
  items : Seq[io.k8s.api.core.v1.PodTemplate],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodTemplateList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.PodTemplate]) : PodTemplateList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.PodTemplate*) : PodTemplateList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodTemplateList = copy(metadata = Some(value))
}

