package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PodTemplate describes a template for creating copies of a predefined pod. */
final case class PodTemplate(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodTemplate", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplate = copy(metadata = Some(value))
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : PodTemplate = copy(template = Some(value))
}

