package io.k8s.api.core.v1


/** PodSpec is a description of a pod. */
final case class PodSpec(
  priority : Option[Int] = None,
  hostIPC : Option[Boolean] = None,
  serviceAccount : Option[String] = None,
  schedulerName : Option[String] = None,
  hostname : Option[String] = None,
  imagePullSecrets : Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  affinity : Option[io.k8s.api.core.v1.Affinity] = None,
  os : Option[io.k8s.api.core.v1.PodOS] = None,
  nodeName : Option[String] = None,
  ephemeralContainers : Option[Seq[io.k8s.api.core.v1.EphemeralContainer]] = None,
  initContainers : Option[Seq[io.k8s.api.core.v1.Container]] = None,
  shareProcessNamespace : Option[Boolean] = None,
  setHostnameAsFQDN : Option[Boolean] = None,
  enableServiceLinks : Option[Boolean] = None,
  preemptionPolicy : Option[String] = None,
  dnsPolicy : Option[String] = None,
  volumes : Option[Seq[io.k8s.api.core.v1.Volume]] = None,
  hostAliases : Option[Seq[io.k8s.api.core.v1.HostAlias]] = None,
  subdomain : Option[String] = None,
  topologySpreadConstraints : Option[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]] = None,
  overhead : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  tolerations : Option[Seq[io.k8s.api.core.v1.Toleration]] = None,
  automountServiceAccountToken : Option[Boolean] = None,
  nodeSelector : Option[Map[String, String]] = None,
  hostPID : Option[Boolean] = None,
  terminationGracePeriodSeconds : Option[Int] = None,
  containers : Seq[io.k8s.api.core.v1.Container],
  dnsConfig : Option[io.k8s.api.core.v1.PodDNSConfig] = None,
  priorityClassName : Option[String] = None,
  serviceAccountName : Option[String] = None,
  restartPolicy : Option[String] = None,
  hostUsers : Option[Boolean] = None,
  runtimeClassName : Option[String] = None,
  readinessGates : Option[Seq[io.k8s.api.core.v1.PodReadinessGate]] = None,
  activeDeadlineSeconds : Option[Int] = None,
  hostNetwork : Option[Boolean] = None,
  securityContext : Option[io.k8s.api.core.v1.PodSecurityContext] = None
) {
  def withPriority(value: Int) : PodSpec = copy(priority = Some(value))
  def withHostIPC(value: Boolean) : PodSpec = copy(hostIPC = Some(value))
  def withServiceAccount(value: String) : PodSpec = copy(serviceAccount = Some(value))
  def withSchedulerName(value: String) : PodSpec = copy(schedulerName = Some(value))
  def withHostname(value: String) : PodSpec = copy(hostname = Some(value))
  def withImagePullSecrets(value: Seq[io.k8s.api.core.v1.LocalObjectReference]) : PodSpec = copy(imagePullSecrets = Some(value))
  def addImagePullSecrets(newValues: io.k8s.api.core.v1.LocalObjectReference*) : PodSpec = copy(imagePullSecrets = Some(imagePullSecrets.fold(newValues)(_ ++ newValues)))

  def withAffinity(value: io.k8s.api.core.v1.Affinity) : PodSpec = copy(affinity = Some(value))
  def withOs(value: io.k8s.api.core.v1.PodOS) : PodSpec = copy(os = Some(value))
  def withNodeName(value: String) : PodSpec = copy(nodeName = Some(value))
  def withEphemeralContainers(value: Seq[io.k8s.api.core.v1.EphemeralContainer]) : PodSpec = copy(ephemeralContainers = Some(value))
  def addEphemeralContainers(newValues: io.k8s.api.core.v1.EphemeralContainer*) : PodSpec = copy(ephemeralContainers = Some(ephemeralContainers.fold(newValues)(_ ++ newValues)))

  def withInitContainers(value: Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(initContainers = Some(value))
  def addInitContainers(newValues: io.k8s.api.core.v1.Container*) : PodSpec = copy(initContainers = Some(initContainers.fold(newValues)(_ ++ newValues)))

  def withShareProcessNamespace(value: Boolean) : PodSpec = copy(shareProcessNamespace = Some(value))
  def withSetHostnameAsFQDN(value: Boolean) : PodSpec = copy(setHostnameAsFQDN = Some(value))
  def withEnableServiceLinks(value: Boolean) : PodSpec = copy(enableServiceLinks = Some(value))
  def withPreemptionPolicy(value: String) : PodSpec = copy(preemptionPolicy = Some(value))
  def withDnsPolicy(value: String) : PodSpec = copy(dnsPolicy = Some(value))
  def withVolumes(value: Seq[io.k8s.api.core.v1.Volume]) : PodSpec = copy(volumes = Some(value))
  def addVolumes(newValues: io.k8s.api.core.v1.Volume*) : PodSpec = copy(volumes = Some(volumes.fold(newValues)(_ ++ newValues)))

  def withHostAliases(value: Seq[io.k8s.api.core.v1.HostAlias]) : PodSpec = copy(hostAliases = Some(value))
  def addHostAliases(newValues: io.k8s.api.core.v1.HostAlias*) : PodSpec = copy(hostAliases = Some(hostAliases.fold(newValues)(_ ++ newValues)))

  def withSubdomain(value: String) : PodSpec = copy(subdomain = Some(value))
  def withTopologySpreadConstraints(value: Seq[io.k8s.api.core.v1.TopologySpreadConstraint]) : PodSpec = copy(topologySpreadConstraints = Some(value))
  def addTopologySpreadConstraints(newValues: io.k8s.api.core.v1.TopologySpreadConstraint*) : PodSpec = copy(topologySpreadConstraints = Some(topologySpreadConstraints.fold(newValues)(_ ++ newValues)))

  def withOverhead(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PodSpec = copy(overhead = Some(value))
  def addOverhead(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PodSpec = copy(overhead = Some(overhead.fold(newValues.toMap)(_ ++ newValues)))

  def withTolerations(value: Seq[io.k8s.api.core.v1.Toleration]) : PodSpec = copy(tolerations = Some(value))
  def addTolerations(newValues: io.k8s.api.core.v1.Toleration*) : PodSpec = copy(tolerations = Some(tolerations.fold(newValues)(_ ++ newValues)))

  def withAutomountServiceAccountToken(value: Boolean) : PodSpec = copy(automountServiceAccountToken = Some(value))
  def withNodeSelector(value: Map[String, String]) : PodSpec = copy(nodeSelector = Some(value))
  def addNodeSelector(newValues: (String, String)*) : PodSpec = copy(nodeSelector = Some(nodeSelector.fold(newValues.toMap)(_ ++ newValues)))

  def withHostPID(value: Boolean) : PodSpec = copy(hostPID = Some(value))
  def withTerminationGracePeriodSeconds(value: Int) : PodSpec = copy(terminationGracePeriodSeconds = Some(value))
  def withContainers(value: Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(containers = value)
  def addContainers(newValues: io.k8s.api.core.v1.Container*) : PodSpec = copy(containers = containers ++ newValues)

  def withDnsConfig(value: io.k8s.api.core.v1.PodDNSConfig) : PodSpec = copy(dnsConfig = Some(value))
  def withPriorityClassName(value: String) : PodSpec = copy(priorityClassName = Some(value))
  def withServiceAccountName(value: String) : PodSpec = copy(serviceAccountName = Some(value))
  def withRestartPolicy(value: String) : PodSpec = copy(restartPolicy = Some(value))
  def withHostUsers(value: Boolean) : PodSpec = copy(hostUsers = Some(value))
  def withRuntimeClassName(value: String) : PodSpec = copy(runtimeClassName = Some(value))
  def withReadinessGates(value: Seq[io.k8s.api.core.v1.PodReadinessGate]) : PodSpec = copy(readinessGates = Some(value))
  def addReadinessGates(newValues: io.k8s.api.core.v1.PodReadinessGate*) : PodSpec = copy(readinessGates = Some(readinessGates.fold(newValues)(_ ++ newValues)))

  def withActiveDeadlineSeconds(value: Int) : PodSpec = copy(activeDeadlineSeconds = Some(value))
  def withHostNetwork(value: Boolean) : PodSpec = copy(hostNetwork = Some(value))
  def withSecurityContext(value: io.k8s.api.core.v1.PodSecurityContext) : PodSpec = copy(securityContext = Some(value))
}

