package io.k8s.api.core.v1


/** PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext. */
final case class PodSecurityContext(
  fsGroupChangePolicy : Option[String] = None,
  sysctls : Option[Seq[io.k8s.api.core.v1.Sysctl]] = None,
  fsGroup : Option[Int] = None,
  supplementalGroups : Option[Seq[Int]] = None,
  runAsGroup : Option[Int] = None,
  seccompProfile : Option[io.k8s.api.core.v1.SeccompProfile] = None,
  windowsOptions : Option[io.k8s.api.core.v1.WindowsSecurityContextOptions] = None,
  seLinuxOptions : Option[io.k8s.api.core.v1.SELinuxOptions] = None,
  runAsUser : Option[Int] = None,
  runAsNonRoot : Option[Boolean] = None
) {
  def withFsGroupChangePolicy(value: String) : PodSecurityContext = copy(fsGroupChangePolicy = Some(value))
  def withSysctls(value: Seq[io.k8s.api.core.v1.Sysctl]) : PodSecurityContext = copy(sysctls = Some(value))
  def addSysctls(newValues: io.k8s.api.core.v1.Sysctl*) : PodSecurityContext = copy(sysctls = Some(sysctls.fold(newValues)(_ ++ newValues)))

  def withFsGroup(value: Int) : PodSecurityContext = copy(fsGroup = Some(value))
  def withSupplementalGroups(value: Seq[Int]) : PodSecurityContext = copy(supplementalGroups = Some(value))
  def addSupplementalGroups(newValues: Int*) : PodSecurityContext = copy(supplementalGroups = Some(supplementalGroups.fold(newValues)(_ ++ newValues)))

  def withRunAsGroup(value: Int) : PodSecurityContext = copy(runAsGroup = Some(value))
  def withSeccompProfile(value: io.k8s.api.core.v1.SeccompProfile) : PodSecurityContext = copy(seccompProfile = Some(value))
  def withWindowsOptions(value: io.k8s.api.core.v1.WindowsSecurityContextOptions) : PodSecurityContext = copy(windowsOptions = Some(value))
  def withSeLinuxOptions(value: io.k8s.api.core.v1.SELinuxOptions) : PodSecurityContext = copy(seLinuxOptions = Some(value))
  def withRunAsUser(value: Int) : PodSecurityContext = copy(runAsUser = Some(value))
  def withRunAsNonRoot(value: Boolean) : PodSecurityContext = copy(runAsNonRoot = Some(value))
}

