package io.k8s.api.core.v1


/** IP address information for entries in the (plural) PodIPs field. Each entry includes:

	IP: An IP address allocated to the pod. Routable at least within the cluster. */
final case class PodIP(
  ip : Option[String] = None
) {
  def withIp(value: String) : PodIP = copy(ip = Some(value))
}

