package io.k8s.api.core.v1


/** PodDNSConfigOption defines DNS resolver options of a pod. */
final case class PodDNSConfigOption(
  name : Option[String] = None,
  value : Option[String] = None
) {
  def withName(value: String) : PodDNSConfigOption = copy(name = Some(value))
  def withValue(value: String) : PodDNSConfigOption = copy(value = Some(value))
}

