package io.k8s.api.core.v1


/** Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running */
final case class PodAffinityTerm(
  labelSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  namespaces : Option[Seq[String]] = None,
  topologyKey : String
) {
  def withLabelSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodAffinityTerm = copy(labelSelector = Some(value))
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodAffinityTerm = copy(namespaceSelector = Some(value))
  def withNamespaces(value: Seq[String]) : PodAffinityTerm = copy(namespaces = Some(value))
  def addNamespaces(newValues: String*) : PodAffinityTerm = copy(namespaces = Some(namespaces.fold(newValues)(_ ++ newValues)))

  def withTopologyKey(value: String) : PodAffinityTerm = copy(topologyKey = value)
}

