package io.k8s.api.core.v1


/** Pod affinity is a group of inter pod affinity scheduling rules. */
final case class PodAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]] = None
) {
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.WeightedPodAffinityTerm*) : PodAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))

  def withRequiredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
  def addRequiredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PodAffinityTerm*) : PodAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(requiredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))

}

