package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts. */
final case class Pod(
  status : Option[io.k8s.api.core.v1.PodStatus] = None,
  spec : Option[io.k8s.api.core.v1.PodSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Pod", "v1")

  def withStatus(value: io.k8s.api.core.v1.PodStatus) : Pod = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.PodSpec) : Pod = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Pod = copy(metadata = Some(value))
}

